<?php

/**
 * Template Name: Blog Small Image
 */

global $theme_option;
get_header(); ?>

<!-- page title -->
<div class="page_title">
    <div class="container">
        <div class="leaft_title"><h1><?php the_title(); ?></h1><?php aoxhost_breadcrumbs(); ?> </div> 
              
    </div>
</div><!-- end page title -->

<!-- content begin -->
<div id="content">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <div class="blog-list">
                 <?php if(have_posts()) : ?>  
                    <?php 
                    $args = array(    
                      'paged' => $paged,
                      'post_type' => 'post',
                      );
                    $wp_query = new WP_Query($args);
                    while ($wp_query -> have_posts()): $wp_query -> the_post(); ?> 
                    <?php $format = get_post_format($post->ID); ?>  
                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                      <div class="post-content">   
                      <div class="image_frame small">
                        <?php if($format=='image'){ ?>
                            <div class="post-image">
                                <?php if( function_exists( 'rwmb_meta' ) ) { ?>
                                  <?php $images = rwmb_meta( '_cmb_image', "type=image" ); ?>
                                  <?php if($images){ ?>
                                  <a href="<?php the_permalink(); ?>">
                                  <?php                                                        
                                    foreach ( $images as $image ) {                              
                                    ?>
                                    <?php $img = $image['full_url']; ?>
                                    <img src="<?php echo esc_url($img); ?>" alt="">
                                    <?php } ?>  
                                  </a>
                                  <?php } ?>
                                <?php } ?>  
                              </div>
                        <?php }elseif($format=='gallery'){ ?>   
                           <div class="post-image">
                                <div class="slider flexslider">
                                  <?php if( function_exists( 'rwmb_meta' ) ) { ?>
                                    <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>
                                    <?php if($images){ ?>
                                      <ul class="slides">
                                        <?php                                                        
                                          foreach ( $images as $image ) {                              
                                        ?>
                                        <?php $img = $image['full_url']; ?>
                                          <li><img src="<?php echo esc_url($img); ?>" alt=""></li> 
                                        <?php } ?>                   
                                      </ul>
                                    <?php } ?>
                                  <?php } ?>
                                </div>
                            </div>
                        <!-- Audio -->
                        <?php }elseif($format == 'audio'){ ?>
                            <div class="video_frame"> 
                                <?php $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true);?>
                                <?php if($link_audio !=''){?>
                                    <iframe width="100%" height="166" src="<?php echo get_post_meta(get_the_ID(),'_cmb_link_audio', true);?>"></iframe>
                                <?php }?>                   
                            <!-- Video -->
                            </div>
                        <?php }elseif($format=='video'){ ?>
                            <div class="video_frame"> 
                                <?php $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true);?>
                                <?php if($link_video !=''){?>                            
                                    <iframe src="<?php echo get_post_meta(get_the_ID(),'_cmb_link_video', true);?>"></iframe>                            
                                <?php }?>
                            </div>    
                        <?php }else{ ?>                    
                          <?php if ( has_post_thumbnail() ) { ?>
                            <div class="post-image">
                              <?php the_post_thumbnail(); ?>
                            </div>
                          <?php } ?> 
                        <?php } ?> 
                        </div>
                        <div class="post_info_content_small">
                          <div class="date-box"><span class="day"><?php the_time('d'); ?></span> <span class="month"><?php the_time('M'); ?></span> </div>   
                          <div class="post-text post-text-no-image">
                              <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                              <ul class="post-meta">
                                <li><i class="fa fa-user"></i><?php the_author_posts_link(); ?></li> 
                                <?php if(has_category()) { ?>
                                <li><i class="fa fa-folder-open"></i><?php the_category(', '); ?></li> 
                                <?php } ?>
                                <li><i class="fa fa-comment"></i><a href="<?php comments_link(); ?>"><?php comments_number( __('0 comment', 'aoxhost'), __('1 comment', 'aoxhost'), __('% comments', 'aoxhost') ); ?></a></li>            
                              </ul>                              
                          </div>
                          <div class="clearfix"></div>
                          <p><?php echo aoxhost_excerpt(); ?></p>
                        </div>  
                        <div class="clearfix"></div>
                      </div>
                    </div> 
                    <?php endwhile;?> 
                    <?php else: ?>
                    <h1><?php _e('Nothing Found Here!', 'aoxhost'); ?></h1>
                    <?php endif; ?>        
                </div>

                <div class="pagination text-center ">
                    <ul>
                        <?php echo aoxhost_pagination(); ?>
                    </ul>
                </div>
            </div>

            <div class="col-md-3">
                <?php get_sidebar();?>
            </div>
        </div>
    </div>
</div>

<!-- content close -->

<?php get_footer(); ?>