<?php
/**
 * The list of countries and dependent territories based on ISO 3166 standard.
 *
 * Source: http://en.wikipedia.org/wiki/ISO_3166-1 ISO 3166-1
 */
class Listo_Countries implements Listo {

	private static $items = array(
		'abw' => "Aruba",
		'afg' => "Afghanistan",
		'ago' => "Angola",
		'aia' => "Anguilla",
		'ala' => "Åland Islands",
		'alb' => "Albania",
		'and' => "Andorra",
		'are' => "United Arab Emirates",
		'arg' => "Argentina",
		'arm' => "Armenia",
		'asm' => "American Samoa",
		'ata' => "Antarctica",
		'atf' => "French Southern Territories",
		'atg' => "Antigua and Barbuda",
		'aus' => "Australia",
		'aut' => "Austria",
		'aze' => "Azerbaijan",
		'bdi' => "Burundi",
		'bel' => "Belgium",
		'ben' => "Benin",
		'bes' => "Bonaire, Sint Eustatius and Saba",
		'bfa' => "Burkina Faso",
		'bgd' => "Bangladesh",
		'bgr' => "Bulgaria",
		'bhr' => "Bahrain",
		'bhs' => "Bahamas",
		'bih' => "Bosnia and Herzegovina",
		'blm' => "Saint Barthélemy",
		'blr' => "Belarus",
		'blz' => "Belize",
		'bmu' => "Bermuda",
		'bol' => "Bolivia, Plurinational State of",
		'bra' => "Brazil",
		'brb' => "Barbados",
		'brn' => "Brunei Darussalam",
		'btn' => "Bhutan",
		'bvt' => "Bouvet Island",
		'bwa' => "Botswana",
		'caf' => "Central African Republic",
		'can' => "Canada",
		'cck' => "Cocos (Keeling) Islands",
		'che' => "Switzerland",
		'chl' => "Chile",
		'chn' => "China",
		'civ' => "Côte d'Ivoire",
		'cmr' => "Cameroon",
		'cod' => "Congo, the Democratic Republic of the",
		'cog' => "Congo",
		'cok' => "Cook Islands",
		'col' => "Colombia",
		'com' => "Comoros",
		'cpv' => "Cape Verde",
		'cri' => "Costa Rica",
		'cub' => "Cuba",
		'cuw' => "Curaçao",
		'cxr' => "Christmas Island",
		'cym' => "Cayman Islands",
		'cyp' => "Cyprus",
		'cze' => "Czech Republic",
		'deu' => "Germany",
		'dji' => "Djibouti",
		'dma' => "Dominica",
		'dnk' => "Denmark",
		'dom' => "Dominican Republic",
		'dza' => "Algeria",
		'ecu' => "Ecuador",
		'egy' => "Egypt",
		'eri' => "Eritrea",
		'esh' => "Western Sahara",
		'esp' => "Spain",
		'est' => "Estonia",
		'eth' => "Ethiopia",
		'fin' => "Finland",
		'fji' => "Fiji",
		'flk' => "Falkland Islands (Malvinas)",
		'fra' => "France",
		'fro' => "Faroe Islands",
		'fsm' => "Micronesia, Federated States of",
		'gab' => "Gabon",
		'gbr' => "United Kingdom",
		'geo' => "Georgia",
		'ggy' => "Guernsey",
		'gha' => "Ghana",
		'gib' => "Gibraltar",
		'gin' => "Guinea",
		'glp' => "Guadeloupe",
		'gmb' => "Gambia",
		'gnb' => "Guinea-Bissau",
		'gnq' => "Equatorial Guinea",
		'grc' => "Greece",
		'grd' => "Grenada",
		'grl' => "Greenland",
		'gtm' => "Guatemala",
		'guf' => "French Guiana",
		'gum' => "Guam",
		'guy' => "Guyana",
		'hkg' => "Hong Kong",
		'hmd' => "Heard Island and McDonald Islands",
		'hnd' => "Honduras",
		'hrv' => "Croatia",
		'hti' => "Haiti",
		'hun' => "Hungary",
		'idn' => "Indonesia",
		'imn' => "Isle of Man",
		'ind' => "India",
		'iot' => "British Indian Ocean Territory",
		'irl' => "Ireland",
		'irn' => "Iran, Islamic Republic of",
		'irq' => "Iraq",
		'isl' => "Iceland",
		'isr' => "Israel",
		'ita' => "Italy",
		'jam' => "Jamaica",
		'jey' => "Jersey",
		'jor' => "Jordan",
		'jpn' => "Japan",
		'kaz' => "Kazakhstan",
		'ken' => "Kenya",
		'kgz' => "Kyrgyzstan",
		'khm' => "Cambodia",
		'kir' => "Kiribati",
		'kna' => "Saint Kitts and Nevis",
		'kor' => "Korea, Republic of",
		'kwt' => "Kuwait",
		'lao' => "Lao People's Democratic Republic",
		'lbn' => "Lebanon",
		'lbr' => "Liberia",
		'lby' => "Libya",
		'lca' => "Saint Lucia",
		'lie' => "Liechtenstein",
		'lka' => "Sri Lanka",
		'lso' => "Lesotho",
		'ltu' => "Lithuania",
		'lux' => "Luxembourg",
		'lva' => "Latvia",
		'mac' => "Macao",
		'maf' => "Saint Martin (French part)",
		'mar' => "Morocco",
		'mco' => "Monaco",
		'mda' => "Moldova, Republic of",
		'mdg' => "Madagascar",
		'mdv' => "Maldives",
		'mex' => "Mexico",
		'mhl' => "Marshall Islands",
		'mkd' => "Macedonia, the former Yugoslav Republic of",
		'mli' => "Mali",
		'mlt' => "Malta",
		'mmr' => "Myanmar",
		'mne' => "Montenegro",
		'mng' => "Mongolia",
		'mnp' => "Northern Mariana Islands",
		'moz' => "Mozambique",
		'mrt' => "Mauritania",
		'msr' => "Montserrat",
		'mtq' => "Martinique",
		'mus' => "Mauritius",
		'mwi' => "Malawi",
		'mys' => "Malaysia",
		'myt' => "Mayotte",
		'nam' => "Namibia",
		'ncl' => "New Caledonia",
		'ner' => "Niger",
		'nfk' => "Norfolk Island",
		'nga' => "Nigeria",
		'nic' => "Nicaragua",
		'niu' => "Niue",
		'nld' => "Netherlands",
		'nor' => "Norway",
		'npl' => "Nepal",
		'nru' => "Nauru",
		'nzl' => "New Zealand",
		'omn' => "Oman",
		'pak' => "Pakistan",
		'pan' => "Panama",
		'pcn' => "Pitcairn",
		'per' => "Peru",
		'phl' => "Philippines",
		'plw' => "Palau",
		'png' => "Papua New Guinea",
		'pol' => "Poland",
		'pri' => "Puerto Rico",
		'prk' => "Korea, Democratic People's Republic of",
		'prt' => "Portugal",
		'pry' => "Paraguay",
		'pse' => "Palestine, State of",
		'pyf' => "French Polynesia",
		'qat' => "Qatar",
		'reu' => "Réunion",
		'rou' => "Romania",
		'rus' => "Russian Federation",
		'rwa' => "Rwanda",
		'sau' => "Saudi Arabia",
		'sdn' => "Sudan",
		'sen' => "Senegal",
		'sgp' => "Singapore",
		'sgs' => "South Georgia and the South Sandwich Islands",
		'shn' => "Saint Helena, Ascension and Tristan da Cunha",
		'sjm' => "Svalbard and Jan Mayen",
		'slb' => "Solomon Islands",
		'sle' => "Sierra Leone",
		'slv' => "El Salvador",
		'smr' => "San Marino",
		'som' => "Somalia",
		'spm' => "Saint Pierre and Miquelon",
		'srb' => "Serbia",
		'ssd' => "South Sudan",
		'stp' => "Sao Tome and Principe",
		'sur' => "Suriname",
		'svk' => "Slovakia",
		'svn' => "Slovenia",
		'swe' => "Sweden",
		'swz' => "Swaziland",
		'sxm' => "Sint Maarten (Dutch part)",
		'syc' => "Seychelles",
		'syr' => "Syrian Arab Republic",
		'tca' => "Turks and Caicos Islands",
		'tcd' => "Chad",
		'tgo' => "Togo",
		'tha' => "Thailand",
		'tjk' => "Tajikistan",
		'tkl' => "Tokelau",
		'tkm' => "Turkmenistan",
		'tls' => "Timor-Leste",
		'ton' => "Tonga",
		'tto' => "Trinidad and Tobago",
		'tun' => "Tunisia",
		'tur' => "Turkey",
		'tuv' => "Tuvalu",
		'twn' => "Taiwan, Province of China",
		'tza' => "Tanzania, United Republic of",
		'uga' => "Uganda",
		'ukr' => "Ukraine",
		'umi' => "United States Minor Outlying Islands",
		'ury' => "Uruguay",
		'usa' => "United States",
		'uzb' => "Uzbekistan",
		'vat' => "Holy See (Vatican City State)",
		'vct' => "Saint Vincent and the Grenadines",
		'ven' => "Venezuela, Bolivarian Republic of",
		'vgb' => "Virgin Islands, British",
		'vir' => "Virgin Islands, U.S.",
		'vnm' => "Viet Nam",
		'vut' => "Vanuatu",
		'wlf' => "Wallis and Futuna",
		'wsm' => "Samoa",
		'yem' => "Yemen",
		'zaf' => "South Africa",
		'zmb' => "Zambia",
		'zwe' => "Zimbabwe" );

	private static $groups = array(
		'un' => array( 'afg', 'ago', 'alb', 'and', 'are', 'arg', 'arm',
			'atg', 'aus', 'aut', 'aze', 'bdi', 'bel', 'ben', 'bfa', 'bgd',
			'bgr', 'bhr', 'bhs', 'bih', 'blr', 'blz', 'bol', 'bra', 'brb',
			'brn', 'btn', 'bwa', 'caf', 'can', 'che', 'chl', 'chn', 'civ',
			'cmr', 'cod', 'cog', 'col', 'com', 'cpv', 'cri', 'cub', 'cyp',
			'cze', 'deu', 'dji', 'dma', 'dnk', 'dom', 'dza', 'ecu', 'egy',
			'eri', 'esp', 'est', 'eth', 'fin', 'fji', 'fra', 'fsm', 'gab',
			'gbr', 'geo', 'gha', 'gin', 'gmb', 'gnb', 'gnq', 'grc', 'grd',
			'gtm', 'guy', 'hnd', 'hrv', 'hti', 'hun', 'idn', 'ind', 'irl',
			'irn', 'irq', 'isl', 'isr', 'ita', 'jam', 'jor', 'jpn', 'kaz',
			'ken', 'kgz', 'khm', 'kir', 'kna', 'kor', 'kwt', 'lao', 'lbn',
			'lbr', 'lby', 'lca', 'lie', 'lka', 'lso', 'ltu', 'lux', 'lva',
			'mar', 'mco', 'mda', 'mdg', 'mdv', 'mex', 'mhl', 'mkd', 'mli',
			'mlt', 'mmr', 'mne', 'mng', 'moz', 'mrt', 'mus', 'mwi', 'mys',
			'nam', 'ner', 'nga', 'nic', 'nld', 'nor', 'npl', 'nru', 'nzl',
			'omn', 'pak', 'pan', 'per', 'phl', 'plw', 'png', 'pol', 'prk',
			'prt', 'pry', 'qat', 'rou', 'rus', 'rwa', 'sau', 'sdn', 'sen',
			'sgp', 'slb', 'sle', 'slv', 'smr', 'som', 'srb', 'ssd', 'stp',
			'sur', 'svk', 'svn', 'swe', 'swz', 'syc', 'syr', 'tcd', 'tgo',
			'tha', 'tjk', 'tkm', 'tls', 'ton', 'tto', 'tun', 'tur', 'tuv',
			'tza', 'uga', 'ukr', 'ury', 'usa', 'uzb', 'vct', 'ven', 'vnm',
			'vut', 'wsm', 'yem', 'zaf', 'zmb', 'zwe' ),
		'olympic' => array( 'abw', 'afg', 'ago', 'alb', 'and', 'are', 'arg',
			'arm', 'asm', 'atg', 'aus', 'aut', 'aze', 'bdi', 'bel', 'ben',
			'bfa', 'bgd', 'bgr', 'bhr', 'bhs', 'bih', 'blr', 'blz', 'bmu',
			'bol', 'bra', 'brb', 'brn', 'btn', 'bwa', 'caf', 'can', 'che',
			'chl', 'chn', 'civ', 'cmr', 'cod', 'cog', 'cok', 'col', 'com',
			'cpv', 'cri', 'cub', 'cym', 'cyp', 'cze', 'deu', 'dji', 'dma',
			'dnk', 'dom', 'dza', 'ecu', 'egy', 'eri', 'esp', 'est', 'eth',
			'fin', 'fji', 'fra', 'fsm', 'gab', 'gbr', 'geo', 'gha', 'gin',
			'gmb', 'gnb', 'gnq', 'grc', 'grd', 'gtm', 'gum', 'guy', 'hkg',
			'hnd', 'hrv', 'hti', 'hun', 'idn', 'ind', 'irl', 'irn', 'irq',
			'isl', 'isr', 'ita', 'jam', 'jor', 'jpn', 'kaz', 'ken', 'kgz',
			'khm', 'kir', 'kna', 'kor', 'kwt', 'lao', 'lbn', 'lbr', 'lby',
			'lca', 'lie', 'lka', 'lso', 'ltu', 'lux', 'lva', 'mar', 'mco',
			'mda', 'mdg', 'mdv', 'mex', 'mhl', 'mkd', 'mli', 'mlt', 'mmr',
			'mne', 'mng', 'moz', 'mrt', 'mus', 'mwi', 'mys', 'nam', 'ner',
			'nga', 'nic', 'nld', 'nor', 'npl', 'nru', 'nzl', 'omn', 'pak',
			'pan', 'per', 'phl', 'plw', 'png', 'pol', 'pri', 'prk', 'prt',
			'pry', 'pse', 'qat', 'rou', 'rus', 'rwa', 'sau', 'sdn', 'sen',
			'sgp', 'slb', 'sle', 'slv', 'smr', 'som', 'srb', 'stp', 'sur',
			'svk', 'svn', 'swe', 'swz', 'syc', 'syr', 'tcd', 'tgo', 'tha',
			'tjk', 'tkm', 'tls', 'ton', 'tto', 'tun', 'tur', 'tuv', 'twn',
			'tza', 'uga', 'ukr', 'ury', 'usa', 'uzb', 'vct', 'ven', 'vir',
			'vnm', 'vut', 'wsm', 'yem', 'zaf', 'zmb', 'zwe' ) );

	private function __construct() {}

	public static function items() {
		return self::$items;
	}

	public static function groups() {
		return self::$groups;
	}

}
