<?php
/**
 * The list of currencies based on ISO 4217 standard.
 *
 * Source: http://en.wikipedia.org/wiki/ISO_4217 ISO 4217
 *
 * Some special codes for funds, complementary currencies, precious metals
 * and used in testing are excluded.
 */
class Listo_Currencies implements Listo {

	private static $items = array(
		'aed' => "United Arab Emirates dirham",
		'afn' => "Afghan afghani",
		'all' => "Albanian lek",
		'amd' => "Armenian dram",
		'ang' => "Netherlands Antillean guilder",
		'aoa' => "Angolan kwanza",
		'ars' => "Argentine peso",
		'aud' => "Australian dollar",
		'awg' => "Aruban florin",
		'azn' => "Azerbaijani manat",
		'bam' => "Bosnia and Herzegovina convertible mark",
		'bbd' => "Barbados dollar",
		'bdt' => "Bangladeshi taka",
		'bgn' => "Bulgarian lev",
		'bhd' => "Bahraini dinar",
		'bif' => "Burundian franc",
		'bmd' => "Bermudian dollar",
		'bnd' => "Brunei dollar",
		'bob' => "Boliviano",
		'brl' => "Brazilian real",
		'bsd' => "Bahamian dollar",
		'btn' => "Bhutanese ngultrum",
		'bwp' => "Botswana pula",
		'byr' => "Belarusian ruble",
		'bzd' => "Belize dollar",
		'cad' => "Canadian dollar",
		'cdf' => "Congolese franc",
		'chf' => "Swiss franc",
		'clp' => "Chilean peso",
		'cny' => "Chinese yuan",
		'cop' => "Colombian peso",
		'crc' => "Costa Rican colon",
		'cup' => "Cuban peso",
		'cve' => "Cape Verde escudo",
		'czk' => "Czech koruna",
		'djf' => "Djiboutian franc",
		'dkk' => "Danish krone",
		'dop' => "Dominican peso",
		'dzd' => "Algerian dinar",
		'egp' => "Egyptian pound",
		'ern' => "Eritrean nakfa",
		'etb' => "Ethiopian birr",
		'eur' => "Euro",
		'fjd' => "Fiji dollar",
		'fkp' => "Falkland Islands pound",
		'gbp' => "Pound sterling",
		'gel' => "Georgian lari",
		'ghs' => "Ghanaian cedi",
		'gip' => "Gibraltar pound",
		'gmd' => "Gambian dalasi",
		'gnf' => "Guinean franc",
		'gtq' => "Guatemalan quetzal",
		'gyd' => "Guyanese dollar",
		'hkd' => "Hong Kong dollar",
		'hnl' => "Honduran lempira",
		'hrk' => "Croatian kuna",
		'htg' => "Haitian gourde",
		'huf' => "Hungarian forint",
		'idr' => "Indonesian rupiah",
		'ils' => "Israeli new shekel",
		'inr' => "Indian rupee",
		'iqd' => "Iraqi dinar",
		'irr' => "Iranian rial",
		'isk' => "Icelandic króna",
		'jmd' => "Jamaican dollar",
		'jod' => "Jordanian dinar",
		'jpy' => "Japanese yen",
		'kes' => "Kenyan shilling",
		'kgs' => "Kyrgyzstani som",
		'khr' => "Cambodian riel",
		'kmf' => "Comoro franc",
		'kpw' => "North Korean won",
		'krw' => "South Korean won",
		'kwd' => "Kuwaiti dinar",
		'kyd' => "Cayman Islands dollar",
		'kzt' => "Kazakhstani tenge",
		'lak' => "Lao kip",
		'lbp' => "Lebanese pound",
		'lkr' => "Sri Lankan rupee",
		'lrd' => "Liberian dollar",
		'lsl' => "Lesotho loti",
		'ltl' => "Lithuanian litas",
		'lyd' => "Libyan dinar",
		'mad' => "Moroccan dirham",
		'mdl' => "Moldovan leu",
		'mga' => "Malagasy ariary",
		'mkd' => "Macedonian denar",
		'mmk' => "Myanma kyat",
		'mnt' => "Mongolian tugrik",
		'mop' => "Macanese pataca",
		'mro' => "Mauritanian ouguiya",
		'mur' => "Mauritian rupee",
		'mvr' => "Maldivian rufiyaa",
		'mwk' => "Malawian kwacha",
		'mxn' => "Mexican peso",
		'myr' => "Malaysian ringgit",
		'mzn' => "Mozambican metical",
		'nad' => "Namibian dollar",
		'ngn' => "Nigerian naira",
		'nio' => "Nicaraguan córdoba",
		'nok' => "Norwegian krone",
		'npr' => "Nepalese rupee",
		'nzd' => "New Zealand dollar",
		'omr' => "Omani rial",
		'pab' => "Panamanian balboa",
		'pen' => "Peruvian nuevo sol",
		'pgk' => "Papua New Guinean kina",
		'php' => "Philippine peso",
		'pkr' => "Pakistani rupee",
		'pln' => "Polish złoty",
		'pyg' => "Paraguayan guaraní",
		'qar' => "Qatari riyal",
		'ron' => "Romanian new leu",
		'rsd' => "Serbian dinar",
		'rub' => "Russian ruble",
		'rwf' => "Rwandan franc",
		'sar' => "Saudi riyal",
		'sbd' => "Solomon Islands dollar",
		'scr' => "Seychelles rupee",
		'sdg' => "Sudanese pound",
		'sek' => "Swedish krona/kronor",
		'sgd' => "Singapore dollar",
		'shp' => "Saint Helena pound",
		'sll' => "Sierra Leonean leone",
		'sos' => "Somali shilling",
		'srd' => "Surinamese dollar",
		'ssp' => "South Sudanese pound",
		'std' => "São Tomé and Príncipe dobra",
		'syp' => "Syrian pound",
		'szl' => "Swazi lilangeni",
		'thb' => "Thai baht",
		'tjs' => "Tajikistani somoni",
		'tmt' => "Turkmenistani manat",
		'tnd' => "Tunisian dinar",
		'top' => "Tongan paʻanga",
		'try' => "Turkish lira",
		'ttd' => "Trinidad and Tobago dollar",
		'twd' => "New Taiwan dollar",
		'tzs' => "Tanzanian shilling",
		'uah' => "Ukrainian hryvnia",
		'ugx' => "Ugandan shilling",
		'usd' => "United States dollar",
		'uyu' => "Uruguayan peso",
		'uzs' => "Uzbekistan som",
		'vef' => "Venezuelan bolívar",
		'vnd' => "Vietnamese dong",
		'vuv' => "Vanuatu vatu",
		'wst' => "Samoan tala",
		'xaf' => "CFA franc BEAC",
		'xcd' => "East Caribbean dollar",
		'xof' => "CFA franc BCEAO",
		'xpf' => "CFP franc (franc Pacifique)",
		'yer' => "Yemeni rial",
		'zar' => "South African rand",
		'zmw' => "Zambian kwacha",
		'zwl' => "Zimbabwe dollar" );

	private static $groups = array();

	private function __construct() {}

	public static function items() {
		return self::$items;
	}

	public static function groups() {
		return self::$groups;
	}

}
