<?php
 global $theme_option;

 $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true);
 $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true);
get_header();
?>

<!-- page title -->
<div class="page_title">
    <div class="container">
        <div class="leaft_title">
          <?php if($theme_option['the_blog_single']) { ?>
            <h1><?php the_title(); //echo esc_html( $theme_option['the_blog_single'] ); ?></h1>
          <?php } ?>
<?php aoxhost_breadcrumbs(); ?>
        </div> 
               
    </div>
</div><!-- end page title -->

<!-- CONTENT BLOG -->
  <div id="content">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
            <?php while (have_posts()) : the_post(); ?>
              <?php $format = get_post_format($post->ID); ?>
              <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="post-content"> 
                    <?php if($format=='gallery'){ ?>
                      <div class="post-image">
                        <div class="slider flexslider">
                          <?php if( function_exists( 'rwmb_meta' ) ) { ?>
                            <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>
                            <?php if($images){ ?>
                              <ul class="slides">
                                <?php                                                        
                                  foreach ( $images as $image ) {                              
                                ?>
                                <?php $img = $image['full_url']; ?>
                                  <li><img src="<?php echo esc_url($img); ?>" alt=""></li> 
                                <?php } ?>                   
                              </ul>
                            <?php } ?>
                          <?php } ?>
                        </div>
                    </div>
                    <?php } elseif($format=='image'){ ?>
                      <div class="post-image">
                        <?php if( function_exists( 'rwmb_meta' ) ) { ?>
                          <?php $images = rwmb_meta( '_cmb_image', "type=image" ); ?>
                          <?php if($images){ ?>
                          <a href="<?php the_permalink(); ?>">
                          <?php                                                        
                            foreach ( $images as $image ) {                              
                            ?>
                            <?php $img = $image['full_url']; ?>
                            <img src="<?php echo esc_url($img); ?>" alt="">
                            <?php } ?>  
                          </a>
                          <?php } ?>
                        <?php } ?>  
                      </div>
                    <?php }elseif($format=='video'){ ?>
                      <div class="video_frame">        
                        <iframe height="350" width="810" src="<?php echo esc_url( $link_video ); ?>"></iframe>          
                      </div>
                    <?php }elseif($format=='audio'){ ?>
                      <div class="video_frame">          
                         <iframe style="width:100%" src="<?php echo esc_url( $link_audio ); ?>"></iframe>
                      </div>
                    <?php }else{ ?>                    
                      <?php if ( has_post_thumbnail() ) { ?>
                        <div class="post-image">
                          <?php the_post_thumbnail(); ?>
                        </div>
                      <?php } ?> 
                    <?php } ?>  
                    <div class="date-box"><span class="day"><?php the_time('d'); ?></span> <span class="month"><?php the_time('M'); ?></span> </div>   
                    <div class="post-text post-text-no-image">                        
                        <h3><?php the_title(); ?></h3>                         
                        <ul class="post-meta">
                          <li><i class="fa fa-user"></i><?php the_author_posts_link(); ?></li> 
                          <?php if(has_category()) { ?>
                          <li><i class="fa fa-folder-open"></i><?php the_category(', '); ?></li> 
                          <?php } ?>
                          <li><i class="fa fa-comments"></i><a href="<?php comments_link(); ?>"><?php comments_number( __('0 comment', 'aoxhost'), __('1 comment', 'aoxhost'), __('% comments', 'aoxhost') ); ?></a></li>            
                        </ul>
                        <div class="page-content"><?php the_content(); ?></div>
                    </div>
                    <div class="clearfix"></div>
                </div>
              </div> 
              <?php endwhile;?>
              
              <p style="display: none;"><?php the_tags('', ', ' ); ?></p>
              <div class="clearfix divider_line"></div>            
              <div class="sharepost">
              <h4><?php _e('Share this Post', 'aoxhost') ?></h4>
              <ul>
                <li><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/blog/facebook.png" alt="" /></a></li>
                <li><a target="_blank" href="https://twitter.com/home?status=<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/blog/twitter.png" alt="" /></a></li>
                <li><a target="_blank" href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/blog/google-plus.png" alt="" /></a></li>
                <li><a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/blog/linkedin.png" alt="" /></a></li>
                <li><a target="_blank" href="https://pinterest.com/pin/create/button/?url=&media=&description=<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/blog/pinterest.png" alt="" /></a></li>                
              </ul>            
            </div><!-- end share post links -->                      
            <div class="clearfix"></div>
                      
            <h4><?php _e('About the Author', 'aoxhost') ?></h4>
            <div class="about_author">            
              <?php echo get_avatar( get_the_author_meta( 'ID' ), 80 ); ?>                           
              <?php the_author_posts_link(); ?><br />
              <?php the_author_meta('description'); ?>
            </div><!-- end about author -->       

            <div class="clearfix mar_top3"></div>                        
              <?php if($theme_option['comment'] == 'yes' ) { ?>   
                <div class="clearfix divider_line"></div>       
                <h4><?php _e('Comments', 'aoxhost') ?></h4>          
                <?php comments_template(); ?>               
              <?php } ?>
            </div>

            <div class="col-md-3">
                <?php get_sidebar();?>
            </div>
        </div>
    </div>
 </div>

<?php get_footer(); ?>	





  