<?php

/**
 * Register meta boxes
 *
 * @since 1.0
 *
 * @param array $meta_boxes
 *
 * @return array
 */

function aoxhost_register_meta_boxes( $meta_boxes ) {

	$prefix = '_cmb_';

	// Post format

	$meta_boxes[] = array(
		'id'       => 'format_detail',
		'title'    => __( 'Format Details', 'aoxhost' ),
		'pages'    => array( 'post', 'portfolio' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(

				'name'             => __( 'Image', 'aoxhost' ),

				'id'               => $prefix . 'image',

				'type'             => 'image_advanced',

				'class'            => 'image',

				'max_file_uploads' => 1,

			),

			array(

				'name'  => __( 'Gallery', 'aoxhost' ),

				'id'    => $prefix . 'images',

				'type'  => 'image_advanced',

				'class' => 'gallery',

			),

			array(

				'name'  => __( 'Quote', 'aoxhost' ),

				'id'    => $prefix . 'quote',

				'type'  => 'textarea',

				'cols'  => 20,

				'rows'  => 2,

				'class' => 'quote',

			),

			array(

				'name'  => __( 'Author', 'aoxhost' ),

				'id'    => $prefix . 'quote_author',

				'type'  => 'text',

				'class' => 'quote',

			),

			array(

				'name'  => __( 'Audio', 'aoxhost' ),

				'id'    => $prefix . 'link_audio',

				'type'  => 'textarea',

				'cols'  => 20,

				'rows'  => 2,

				'class' => 'audio',

				'desc' => 'Ex: https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/139083759',

			),

			array(

				'name'  => __( 'Video', 'aoxhost' ),

				'id'    => $prefix . 'link_video',

				'type'  => 'textarea',

				'cols'  => 20,

				'rows'  => 2,

				'class' => 'video',

				'desc' => 'Example: <b>http://www.youtube.com/embed/0ecv0bT9DEo</b> or <b>http://player.vimeo.com/video/47355798</b>',

			),			

		),

	);

	$meta_boxes[] = array(

			'id'       => 'portfolio_dt',

			'title'    => __( 'Portfolio Settings', 'aoxhost' ),

			'pages'    => array( 'portfolio' ),

			'context'  => 'normal',

			'priority' => 'high',

			'autosave' => true,

			'fields'   => array(	
				array(

					'name'  => __( 'Author', 'aoxhost' ),

					'id'    => $prefix . 'project_author',

					'type'  => 'text',

					'class' => '',

				),			

				array(

					'name'  => __( 'Link Project', 'aoxhost' ),

					'id'    => $prefix . 'link_project',

					'type'  => 'text',

					'class' => '',

				),			

			),

		);



	$meta_boxes[] = array(

		'id'       => 'page_dt',

		'title'    => __( 'Page Details', 'aoxhost' ),

		'pages'    => array( 'page' ),

		'context'  => 'normal',

		'priority' => 'high',

		'autosave' => true,

		'fields'   => array(				

			array(

				'name'  => __( 'Page Subtitle', 'aoxhost' ),

				'id'    => $prefix . 'page_sub',

				'type'  => 'text',

				'class' => '',

			),			

		),

	);

	$meta_boxes[] = array(

		'id'       => 'testimonial_dt',

		'title'    => __( 'Testimonial Details', 'aoxhost' ),

		'pages'    => array( 'testimonial' ),

		'context'  => 'normal',

		'priority' => 'high',

		'autosave' => true,

		'fields'   => array(				

			array(

				'name'  => __( 'Job', 'aoxhost' ),

				'id'    => $prefix . 'test_job',

				'type'  => 'text',

				'class' => '',

			),			

		),

	);

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'aoxhost_register_meta_boxes' );

/**
 * Enqueue scripts for admin
 *
 * @since  1.0
 */
function aoxhost_admin_enqueue_scripts( $hook ) {
	// Detect to load un-minify scripts when WP_DEBUG is enable
	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	if ( in_array( $hook, array( 'post.php', 'post-new.php' ) ) ) {
		wp_enqueue_script( 'aoxhost-backend-js', get_template_directory_uri()."/js/admin.js", array( 'jquery' ), '1.0.0', true );
	}
}
add_action( 'admin_enqueue_scripts', 'aoxhost_admin_enqueue_scripts' );

