<?php



/**
 * Tweets widget class
 *
 * @since 2.8.0
 */



class Tweets_Widget extends WP_Widget {







    function Tweets_Widget() {



        $widget_ops = array( 'classname' => 'widget_tweets', 'description' => __('Latest tweets widget ', 'aoxhost') );



        



        $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'tweets-widget' );



        



        parent::__construct( 'tweets-widget', __('AoxHost Latest Tweets', 'aoxhost'), $widget_ops, $control_ops );



    }



    



    function getAgo($timestamp) {



        $difference = time() - $timestamp;







        if ($difference < 60) {



            return $difference." seconds ago";



        } else {



            $difference = round($difference / 60);



        }







        if ($difference < 60) {



            return $difference." minutes ago";



        } else {



            $difference = round($difference / 60);



        }







        if ($difference < 24) {



            return $difference." hours ago";



        }



        else {



            $difference = round($difference / 24);



        }







        if ($difference < 7) {



            return $difference." days ago";



        } else {



            $difference = round($difference / 7);



            return $difference." weeks ago";



        }



    }



    function getConnectionWithAccessToken($cons_key, $cons_secret, $oauth_token, $oauth_token_secret) {



      $connection = new TwitterOAuth($cons_key, $cons_secret, $oauth_token, $oauth_token_secret);



      return $connection;



    }



    function widget( $args, $instance ) {



        extract( $args );







        //Our variables from the widget settings.



        $title = apply_filters('widget_title', $instance['title'] );



        $notweets = $instance['num'];



        $consumerkey = $instance['custommerkey'];



        $consumersecret = $instance['custommersecret'];



        //Test



        



        



        echo htmlspecialchars_decode( $before_widget );



		if ( ! empty( $title ) ){



		echo htmlspecialchars_decode( $args['before_title'] ) . esc_attr( $title ) . htmlspecialchars_decode( $args['after_title'] ); 



        } ?>

            <div class="tweets_block" id="latest-tweets">
				<div class="dotted-latest-tweets" id="tweets-list"></div>
				<div class="riva-insert-menu-here"></div>
			</div>

            <script type="text/javascript">
			(function($) {
				"use strict";

				//
				// Preload images
				//

				$('document').ready(function() {

				var $container = $('body');

				$container.imagesLoaded( function() {
					$('#images-preloader').hide();

                    var config = {
                      "id": '<?php echo esc_attr($consumerkey);?>',
                      "domId": 'tweets-list',
                      "maxTweets": <?php echo esc_attr( $notweets );?>,
                      "enableLinks": true, 
                      "showUser": false,
                      "showTime": false,
                      "showRetweet": false,
                      "lang": 'en'
                    };

                    twitterFetcher.fetch(config);    

                    setTimeout(function() {
						$('#tweets-list').each(function() {
							$(this).find('ul > li').addClass('tweet-item').unwrap('ul');
							$('<i class="fa fa-twitter"></i>').prependTo($(this).find('.tweet-item'));
							//$('.tweet-item').find('p.interact').remove().detach();
							$(this).show();
						})
						$('#latest-tweets').rivaCarousel({
							style:'vertical',
							navigation:'buttons',
							navigation_class:'width-auto float-left margin-top-10',
							navigation_item_class:'slider-nav-btn-2',
							button_left_text:'<i class="fa fa-chevron-up"></i>',
							button_right_text:'<i class="fa fa-chevron-down"></i>',
							visible:2,
							selector:'tweet-item',
							gutter:20,
							infinite:1,
							autostart:0
						});
					}, 2000);                       

				   });
				});

			})(jQuery);

            </script>
		<?php





        echo htmlspecialchars_decode( $after_widget );



    }







    //Update the widget 



     



    function update( $new_instance, $old_instance ) {



        $instance = $old_instance;







        //Strip tags from title and name to remove HTML 



        $instance['title'] = strip_tags( $new_instance['title'] );



        $instance['num'] = strip_tags( $new_instance['num'] );



        $instance['custommerkey'] = strip_tags( $new_instance['custommerkey'] );



        $instance['custommersecret'] = strip_tags( $new_instance['custommersecret'] );







        return $instance;



    }







    



    function form( $instance ) {







        //Set up some default widget settings.



        $defaults = array( 'title' => __('latest tweets', 'aoxhost'), 'name' => __('Suono Libero', 'aoxhost'),'custommerkey' => __('579924271629094913', 'aoxhost'),'custommersecret' => __('twitter-posts-2', 'aoxhost'), 'style' => 'sidebar', 'num' => __(5, 'aoxhost'));



        $instance = wp_parse_args( (array) $instance, $defaults ); ?>







        <p>



            <label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>"><?php _e('Title:', 'aoxhost'); ?></label>



            <input type="text" class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" />



        </p>



        <p>



            <label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'custommerkey' ) ); ?>"><?php _e('Twitter Widget ID:', 'aoxhost'); ?></label></br>(the number you copied, <a target="_blank" href="https://www.youtube.com/watch?v=Ypsib-Nx4VQ">view more</a>)



            <input type="text" class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'custommerkey' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'custommerkey' ) ); ?>" value="<?php echo esc_attr( $instance['custommerkey'] ); ?>" />



        </p>



        <p>



            <label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'num' ) ); ?>"><?php _e('Number of tweets:', 'aoxhost'); ?></label><br>(between 1 and 20)



            <input type="text" class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'num' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'num' ) ); ?>" value="<?php echo esc_attr( $instance['num'] ); ?>" />



        </p>



        <!-- style: Select Box -->





    <?php



    }



}



function aoxhost_register_tweets_widgets() {



    register_widget( 'Tweets_Widget' );



}



add_action( 'widgets_init', 'aoxhost_register_tweets_widgets' ); 



?>