<?php 

// Creating the widget 

class contact_info_widget extends WP_Widget {



function __construct() {

parent::__construct(

// Base ID of your widget

'contact_info_widget', 



// Widget name will appear in UI

__('AoxHost Contact Info', 'aoxhost'), 



// Widget description

array( 'description' => __( 'AoxHost Contact Info Widget', 'aoxhost' ), ) 

);

}



// Creating widget front-end

// This is where the action happens

public function widget( $args, $instance ) {

	// these are the widget options

	$title = apply_filters( 'widget_title', $instance['title'] );

     $email = esc_attr($instance['email']);

	 $phone = esc_attr($instance['phone']);

	 $fax = esc_attr($instance['fax']);

     $address = esc_textarea($instance['address']);	

	 $content = esc_textarea($instance['content']);	 

	 



// before and after widget arguments are defined by themes

echo htmlspecialchars_decode( $args['before_widget'] );

if ( ! empty( $title ) )

echo htmlspecialchars_decode( $args['before_title'] ) .esc_attr( $title ). htmlspecialchars_decode( $args['after_title'] );

?>

<div class="aoxhost-about-widget">

	<p><?php echo htmlspecialchars_decode( $content ); ?></p>
	<div class="clearfix"></div>

	<?php
		// Check if address is set

	   if( $address ) {

	     echo '<p class="contacts"><i class="fa fa-map-marker"></i>'.$address.'</p>';

	   }

		// Check if phone number is set

	   if( $phone ) {

	      echo '<p class="contacts"><i class="fa fa-phone"></i>'.$phone.'</p>';

	   }

	   // Check if fax number is set

	   if( $fax ) {

	      echo '<p class="contacts"><i class="fa fa-fax"></i>'.$fax.'</p>';

	   }

		// Check if email is set

	   if( $email ) {

	      echo '<p class="contacts"><i class="fa fa-envelope"></i><a href="mailto:'.$email.'">'.$email.'</a></p>';

	   }

	?>

	<p class="sm-buttons fleft">

	<?php

		if( $facebook ) {

	      echo '<a href="'.$facebook.'" title="" ><i class="fa fa-facebook"></i></a>';

	   }

	   if( $gplus ) {

	      echo '<a href="'.$gplus.'" title=""><i class="fa fa-google-plus"></i></a>';

	   }

	   if( $twitter ) {

	      echo '<a href="'.$twitter.'" title=""><i class="fa fa-twitter"></i></a>';

	   }

	   if( $youtube ) {

	      echo '<a href="'.$youtube.'" title=""><i class="fa fa-youtube"></i></a>';

	   }

	   if( $linkedin ) {

	      echo '<a href="'.$linkedin.'" title=""><i class="fa fa-linkedin"></i></a>';

	   }

	   if( $dribbble ) {

	      echo '<a href="'.$dribbble.'" title=""><i class="fa fa-dribbble"></i></a>';

	   }

	   if( $skype ) {

	      echo '<a href="'.$skype.'" title=""><i class="fa fa-skype"></i></a>';

	   }  

	?>

	</p>

</div>	



<?php 

echo htmlspecialchars_decode( $args['after_widget'] );

}

		

// Widget Backend 

public function form( $instance ) {

// Check values

if(isset( $instance[ 'title' ] ) || isset ($instance['content']) || isset($instance['style']) || isset( $instance[ 'email' ] ) || isset( $instance[ 'phone' ] ) || isset( $instance[ 'fax' ] ) || isset( $instance[ 'address' ] ) || isset( $instance[ 'facebook' ] ) || isset( $instance[ 'gplus' ] ) || isset( $instance[ 'twitter' ] ) || isset( $instance[ 'youtube' ] ) || isset( $instance[ 'linkedin' ] ) || isset( $instance[ 'dribbble' ] ) || isset( $instance[ 'skype' ] )) {

     $title = esc_attr($instance['title']);

     $email = esc_attr($instance['email']);

	 $phone = esc_attr($instance['phone']);

	 $fax = esc_attr($instance['fax']);

     $address = esc_textarea($instance['address']);

	 $facebook = esc_attr($instance['facebook']); $gplus = esc_attr($instance['gplus']); 

	 $twitter = esc_attr($instance['twitter']); $youtube = esc_attr($instance['youtube']); 

	 $linkedin = esc_attr($instance['linkedin']); $dribbble = esc_attr($instance['dribbble']); 

	 $skype = esc_attr($instance['skype']);

	 $content = esc_attr($instance['content']);

	 $style = $instance['style'];

} else {

     $title = __( 'New title', 'aoxhost' );

     $email = '';

	 $phone = '';

	 $fax = '';

     $address = '';

	 $content = '';

	 $style = 'contactinfo1';

	 $facebook = ''; $gplus = ''; $twitter = ''; $youtube = ''; $linkedin = ''; $dribbble = ''; $skype = '';

}

// Widget admin form

?>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', 'aoxhost' ); ?></label> 

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('content') ); ?>"><?php _e('Content:', 'aoxhost'); ?></label>

<textarea class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('content') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('content') ); ?>"><?php echo esc_attr( $content ); ?></textarea>

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('email') ); ?>"><?php _e('Email', 'aoxhost'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('email') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('email') ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('phone') ); ?>"><?php _e('Phone Number:', 'aoxhost'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('phone') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('phone') ); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('fax') ); ?>"><?php _e('Fax Number:', 'aoxhost'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('fax') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('fax') ); ?>" type="text" value="<?php echo esc_attr( $fax ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('address') ); ?>"><?php _e('Address:', 'aoxhost'); ?></label>

<textarea class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('address') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('address') ); ?>"><?php echo esc_attr( $address ); ?></textarea>

</p>

<?php 

}

	

// Updating widget replacing old instances with new

public function update( $new_instance, $old_instance ) {

$instance = array();

$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

$instance['content'] = ( ! empty( $new_instance['content'] ) ) ? strip_tags( $new_instance['content'] ) : '';

$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';

$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';

$instance['fax'] = ( ! empty( $new_instance['fax'] ) ) ? strip_tags( $new_instance['fax'] ) : '';

$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';

return $instance;

}

} // Class wpb_widget ends here



// Register and load the widget

function wpb_load_widget() {

	register_widget( 'contact_info_widget' );

}

add_action( 'widgets_init', 'wpb_load_widget' );

