<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>
<?php if ( have_comments() ) : ?>
    <ul class="single-comment ">
			<?php wp_list_comments('callback=aoxhost_theme_comment'); ?>
		<?php
			// Are there comments to navigate through?
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
			<nav class="navigation comment-navigation" role="navigation">		   
				<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'aoxhost' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'aoxhost' ) ); ?></div>
			</nav><!-- .comment-navigation -->
		<?php endif; // Check for comment navigation ?>

		<?php if ( ! comments_open() && get_comments_number() ) : ?>
			<p class="no-comments"><?php _e( 'Comments are closed.' , 'aoxhost' ); ?></p>
		<?php endif; ?>	
    </ul>		
<?php endif; ?>		

<div class="leave-reply comment_form">
<?php
    if ( is_singular() ) wp_enqueue_script( "comment-reply" );
        $aria_req = ( $req ? " aria-required='true'" : '' );
        $comment_args = array(
                'id_form' => '',                                
                'title_reply'=> '<h4>'.__('Leave a Comment','aoxhost').'</h4>',
                'fields' => apply_filters( 'comment_form_default_fields', array(
                    'author' => '<input class="comment_input_bg" name="author" id="name" type="text" value="" placeholder="'. __( 'Your Name *', 'aoxhost' ) .'" />',
                    'email' => '<input class="comment_input_bg" value="" id="email" name="email" type="text" placeholder="'. __( 'Your Email *', 'aoxhost' ) .'" />', 
                    'website' => '<input class="comment_input_bg" type="text" name="website" placeholder="'.__('Your Website', 'aoxhost').'">',
                ) ),                                
                 'comment_field' => '<textarea class="comment_textarea_bg" rows="20" cols="7" name="comment"'.$aria_req.' id="comment" placeholder="'. __( 'Your Comment', 'aoxhost' ) .'" ></textarea><div class="clearfix"></div>',                                                   
                 'label_submit' => __( 'Submit Comment', 'aoxhost' ),
                 'class_submit' => 'comment_submit',
                 'comment_notes_before' => '',
                 'comment_notes_after' => '',               
        )
    ?>
    <?php comment_form($comment_args); ?>
</div><!-- //LEAVE A COMMENT -->
<div class="clearfix mar_top2"></div>  
                